'******************************************************************************
' six1 01/2010
' 1-Wire by six1
' Read up to 8 devices
' no single value expected
'******************************************************************************
'*******************************************************************************
'  Pollin NET-IO Board with Atmega32 / 644 / 644P and ENC28J60
'*******************************************************************************
'
'  Copyright bascom-forum.de (C) [2009]  [DON]
'  -> http://bascom-forum.de/index.php?topic=1781.new;topicseen#new
'  Software based on Code by Ben Zijlstra and Viktor Varga
'  Weiterentwickelt von
'    Huetti,
'    Michael
'    boeserkorn
'    mr_energy
'    HansHans
'    six1, Michael Kcher
'    dabuze                            datetime
'    framuel
'
'   http://creativecommons.org/licenses/by-sa/3.0/de/
'
'   Sie drfen:
'
'     * das Werk bzw. den Inhalt vervielfltigen, verbreiten und ffentlich zugnglich machen
'
'     * Abwandlungen und Bearbeitungen des Werkes bzw. Inhaltes anfertigen
'
'   Zu Den Folgenden Bedingungen:
'
'     * Namensnennung.
'       Sie mssen den Namen des Autors/Rechteinhabers in der von ihm festgelegten Weise nennen.
'
'     * Keine kommerzielle Nutzung.
'       Dieses Werk darf nicht fr kommerzielle Zwecke verwendet werden.
'
'     * Weitergabe unter gleichen Bedingungen.
'       Wenn Sie das lizenzierte Werk bzw. den lizenzierten Inhalt bearbeiten
'       oder in anderer Weise erkennbar als Grundlage fr eigenes Schaffen verwenden,
'       drfen Sie die daraufhin neu entstandenen Werke bzw. Inhalte nur
'       unter Verwendung von Lizenzbedingungen weitergeben, die mit denen
'       dieses Lizenzvertrages identisch oder vergleichbar sind.
'
'   Wobei gilt:
'
'     * Verzichtserklrung
'       Jede der vorgenannten Bedingungen kann aufgehoben werden, sofern Sie
'       die ausdrckliche Einwilligung des Rechteinhabers dazu erhalten.
'
'     * Sonstige Rechte
'       Die Lizenz hat keinerlei Einfluss auf die folgenden Rechte:
'          - Die gesetzlichen Schranken des Urheberrechts und sonstigen
'            Befugnisse zur privaten Nutzung
'          - Das Urheberpersnlichkeitsrecht des Rechteinhabers
'          - Rechte anderer Personen, entweder am Lizenzgegenstand selber oder
'            bezglich seiner Verwendung, zum Beispiel Persnlichkeitsrechte abgebildeter Personen.
'
'  Hinweis
'
'      Im Falle einer Verbreitung mssen Sie anderen alle Lizenzbedingungen
'      mitteilen, die fr dieses Werk gelten. Am einfachsten ist es,
'      einen Link auf http://creativecommons.org/licenses/by-sa/3.0/de/ einzubinden.
'

'*******************************************************************************
$nocompile

Sub Temp_initialize
   #if Debug_temp = 1
     Print "-> Init Temp -> "
   #endif
   Call Init_temp
   Waitms 750
   Call Get_temp
End Sub

'-------------------------------------------------------------------------------
' Get_temp
'  liest gewandelte Werte aus und startet neue Wandlung
'  diese Funktion darf nicht schneller als im 1Sek Rythmus aufgerufen werden,
'  da parasit Power Zeit fr die Wandlung braucht!
'  so etwa jede Minute ist auch vllig ok!!!
'-------------------------------------------------------------------------------
Sub Get_temp
       Local Deviceno As Byte
       Local Helptemp As Single
       Local Pos As Byte

       Temp_array_pos = 0
       For Deviceno = 0 To 7
        Pos = 1
        Shift Pos , Left , Deviceno
        Pos = Pos And Temppin
        If Pos > 0 Then
           Incr Temp_array_pos
           Status_temp(temp_array_pos ) = Read_1wire(deviceno , Temp_array_pos )
           #if Debug_temp = 3
           Helptemp = Temperatur(temp_array_pos) / 10
           Select Case Status_temp(temp_array_pos )
             Case 0 :
                      Print "Sensor No." ; Temp_array_pos ; Chr(9) ; Fusing(helptemp , "##.#") ; " C"
             Case 1 :
                      Print "Sensor No." ; Temp_array_pos ; Chr(9) ; "Sensor CRC Error!"
             Case 2 :
                      Print "Sensor No." ; Temp_array_pos ; Chr(9) ; "Kein Sensor!"
             Case Else :
                      Print "Sensor No." ; Temp_array_pos ; Chr(9) ; Str(status_temp(temp_array_pos ))
           End Select
           #endif
           1wreset Tempport , Deviceno
           1wwrite &HCC , 1 , Tempport , Deviceno           'skip ROM command
           1wwrite &H44 , 1 , Tempport , Deviceno           'skip ROM command
         End If
       Next
End Sub

'-------------------------------------------------------------------------------
' Init_temp
'   Initiallisiert die vorhandenen Sensoren.
'   EINMALIG VOR der Mainloop aufrufen
'-------------------------------------------------------------------------------
Sub Init_temp
      'INIT The DS18(B)20 First Time
      Local Deviceno1 As Byte
      Local B_b1 As Byte , B_b2 As Byte
      Local Pos As Byte

      For B_b1 = 1 To Count_temp_pin
      ' Temperatur_min(temp_byte) = 999
      ' Temperatur_max(temp_byte) = -999

        If Ee_temperatur_min(b_b1) = &H7FFF Then
           Ee_temperatur_min(b_b1) = 9999
        End If

        If Ee_temperatur_max(b_b1) = &H7FFF Then
           Ee_temperatur_max(b_b1) = -9999
        End If
        Temperatur_min(b_b1) = Ee_temperatur_min(b_b1)
        Temperatur_max(b_b1) = Ee_temperatur_max(b_b1)
        Temperatur_schwelle(b_b1) = Ee_temperatur_schwelle(b_b1)
      Next

      For Deviceno1 = 0 To 7
        Pos = 1
        Shift Pos , Left , Deviceno1
        Pos = Pos And Temppin
        If Pos > 0 Then
#if Debug_temp = 1
         Print "  Port." ; Deviceno1 ;
#endif

         Dsid(1) = 1wsearchfirst(tempport , Deviceno1)
         If Err = 0 Then
#if Debug_temp = 1
           If Dsid(1) = &H22 Or Dsid(1) = &H28 Then
             Print "  DS18B20    ID: ";
           Else
             Print "  DS18(S)20  ID: ";
           End If
           Print Hex(dsid(1)) ; "-" ; Hex(dsid(2)) ; "-" ; Hex(dsid(3)) ; "-" ; Hex(dsid(4)) ; "-" ; Hex(dsid(5)) ; "-" ; Hex(dsid(6)) ; "-" ; Hex(dsid(7)) ; "-" ; Hex(dsid(8))
#endif
           'First convert
           1wreset Tempport , Deviceno1
           1wwrite &HCC , 1 , Tempport , Deviceno1          'skip ROM command
           1wwrite &H44 , 1 , Tempport , Deviceno1          'skip ROM command
#if Debug_temp = 1
         Else
           Print "  No Device"
#endif
         End If
        End If
      Next
#if Debug_temp = 1
      Print
#endif
End Sub

'-------------------------------------------------------------------------------
' Read_1wire
'   wird von GET_TEMP aufgerufen!
'-------------------------------------------------------------------------------
Function Read_1wire(byref Deviceno As Byte , Byref Temp_array_pos As Byte) As Byte
     Local B_b As Byte , B_c As Byte , B_d As Byte
     Local T1 As Single
     Local T_int As Integer , T_fract As Single , T_word As Word

     Dsid(1) = 1wsearchfirst(tempport , Deviceno)
     If Err = 0 Then
        1wreset Tempport , Deviceno                         'reset the device
        1wwrite &HCC , 1 , Tempport , Deviceno              'read scratchpad
        1wwrite &HBE , 1 , Tempport , Deviceno              'read scratchpad
        Sc(1) = 1wread(9 , Tempport , Deviceno)             'Read 9 Data-Bytes
        Read_1wire = 0
        If Sc(1) = 0 And Sc(2) = 0 And Sc(3) = 0 And Sc(4) = 0 And Sc(5) = 0 And Sc(6) = 0 And Sc(7) = 0 And Sc(8) = 0 Then
           Read_1wire = 2
           Temperatur(temp_array_pos) = &H7FFF
           Goto Ende_temp
        End If
        If Sc(1) = 255 And Sc(2) = 255 And Sc(3) = 255 And Sc(4) = 255 And Sc(5) = 255 And Sc(6) = 255 And Sc(7) = 255 And Sc(8) = 255 Then
           Read_1wire = 2
           Temperatur(temp_array_pos) = &H7FFF
           Goto Ende_temp
        End If


        If Sc(9) = Crc8(sc(1) , 8) Then


            'DS1820s 1-Wire family code: 10h
            'DS18S20s 1-Wire family code: 10h
            '    Specification Differences:
            '     The primary specification difference between the two parts is the
            '     temperature conversion time:
            '     DS1820 = 500ms (max) and DS18S20 = 750ms (max).
            'DS18B20s 1-Wire family code: 28h


            If Dsid(1) = &H22 Or Dsid(1) = &H28 Then        'wenn der Family Code 22 oder 28 ist  (DS18 B 20 )
              Sensor_temp(temp_array_pos) = 1
            Else                                            ' wenn Family Code 10 (DS1820, DS18 S 20)
              Shift Ds_temp , Left , 3                      '9 Bit --> 12 Bit
              Sensor_temp(temp_array_pos) = 2
            End If

            T_int = Ds_temp
            Shift T_int , Right , 4

            T_word = Ds_temp
            Shift T_word , Left , 12
            T_fract = T_word / 65535

            T1 = T_int + T_fract

            T1 = T1 * 10                                    'erweiterung auf eine Nachkommastelle fr Temperatur(int)

            Temperatur(temp_array_pos) = T1

            If Temperatur(temp_array_pos) > Temperatur_max(temp_array_pos) Then
                 Ee_temperatur_max(temp_array_pos) = Temperatur(temp_array_pos)
                 Temperatur_max(temp_array_pos) = Temperatur(temp_array_pos)
            End If

            If Temperatur(temp_array_pos) < Temperatur_min(temp_array_pos) Then
                 Ee_temperatur_min(temp_array_pos) = Temperatur(temp_array_pos)
                 Temperatur_min(temp_array_pos) = Temperatur(temp_array_pos)
            End If

           #if Include_svg = 1
             If Deviceno = 4 Then
              For B_b = 2 To 39
                 B_d = 40 - B_b
                 B_c = B_d + 1
                 Temp_graph(b_c) = Temp_graph(b_d)
              Next
              Temp_graph(1) = T1 / 10
             End If
           #endif

            Read_1wire = 0
         Else
           Temperatur(temp_array_pos) = &H7FFF
           Read_1wire = 1
         End If
     Else
        Read_1wire = 2   
     End If
     Ende_temp:
End Function